/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.apps.designer.images.VWImageLoader;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VWIDMLocalSaveOptionDialog
extends VWModalDialog
implements ActionListener {
    public static final int STATUS_SAVE = 0;
    public static final int STATUS_ADD = 1;
    public static final int STATUS_SAVELOCAL = 2;
    public static final int STATUS_CANCEL = 4;
    public static final int STATUS_YES = 8;
    public static final int STATUS_NO = 16;
    public static final int CHOICE_SAVE_IDM = 0;
    public static final int CHOICE_ADD_IDM = 1;
    public static final int CHOICE_SAVE_LOCAL = 2;
    public static final int DOC_TYPE_WORKFLOW = 0;
    public static final int DOC_TYPE_STEPPALETTE = 1;
    public static final int DOC_TYPE_CONFIGURATION = 2;
    private JRadioButton m_saveAddRadioButton = null;
    private JRadioButton m_saveLocalRadioButton = null;
    private ButtonGroup m_radioGroup = null;
    private JButton m_yesButton = null;
    private JButton m_noButton = null;
    private JButton m_cancelButton = null;
    protected int m_nChoice = 0;
    protected int m_nStatus = 4;
    protected boolean m_bSaveIDMDoc = false;
    protected boolean m_bExit = false;
    protected int m_nDocType = 0;

    public VWIDMLocalSaveOptionDialog(Frame parentFrame, String title, int nDocType, boolean bSaveIDMDoc, boolean bExit) {
        super(parentFrame);
        try {
            this.setTitle(title);
            this.m_nDocType = nDocType;
            this.m_bSaveIDMDoc = bSaveIDMDoc;
            this.m_nChoice = this.m_bSaveIDMDoc ? 0 : 1;
            this.m_bExit = bExit;
            this.initLayout();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWIDMLocalSaveOptionDialog(Frame parent, String title, boolean bSaveIDMDoc, boolean bExit) {
        this(parent, title, 0, bSaveIDMDoc, bExit);
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public int getChoice() {
        return this.m_nChoice;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_saveAddRadioButton) {
                this.performSaveAddIDM();
            } else if (source == this.m_saveLocalRadioButton) {
                this.performSaveLocal();
            } else if (source == this.m_yesButton) {
                this.performYes();
            } else if (source == this.m_noButton) {
                this.performNo();
            } else if (source == this.m_cancelButton) {
                this.performCancel();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void initLayout() {
        try {
            this.getContentPane().setLayout(new BorderLayout(5, 5));
            this.getContentPane().add((Component)this.getMainPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel getMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = -1;
            gbCons.gridheight = 2;
            gbCons.insets = new Insets(5, 5, 2, 10);
            ImageIcon questionIcon = VWImageLoader.createImageIcon("question.gif");
            mainPanel.add((Component)new JLabel(questionIcon), gbCons);
            ++gbCons.gridx;
            ++gbCons.gridy;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(5, 0, 2, 0);
            mainPanel.add((Component)new JLabel(VWResource.s_exitQuestion), gbCons);
            ++gbCons.gridy;
            gbCons.insets = new Insets(0, 0, 2, 0);
            switch (this.m_nDocType) {
                case 0: {
                    if (this.m_bSaveIDMDoc) {
                        this.m_saveAddRadioButton = new JRadioButton(VWIDMBaseFactory.instance().getVWString(22).toString());
                        break;
                    }
                    this.m_saveAddRadioButton = new JRadioButton(VWIDMBaseFactory.instance().getVWString(17).toString());
                    break;
                }
                case 1: {
                    if (this.m_bSaveIDMDoc) {
                        this.m_saveAddRadioButton = new JRadioButton(VWIDMBaseFactory.instance().getVWString(24).toString());
                        break;
                    }
                    this.m_saveAddRadioButton = new JRadioButton(VWIDMBaseFactory.instance().getVWString(19).toString());
                    break;
                }
                case 2: {
                    this.m_saveAddRadioButton = this.m_bSaveIDMDoc ? new JRadioButton(VWIDMBaseFactory.instance().getVWString(25).toString()) : new JRadioButton(VWIDMBaseFactory.instance().getVWString(20).toString());
                }
            }
            this.m_saveAddRadioButton.setSelected(true);
            this.m_saveAddRadioButton.addActionListener(this);
            mainPanel.add((Component)this.m_saveAddRadioButton, gbCons);
            ++gbCons.gridy;
            switch (this.m_nDocType) {
                case 0: {
                    this.m_saveLocalRadioButton = new JRadioButton(VWResource.s_saveFileLocal);
                    break;
                }
                case 1: {
                    this.m_saveLocalRadioButton = new JRadioButton(VWResource.s_saveStepPaletteLocal);
                    break;
                }
                case 2: {
                    this.m_saveLocalRadioButton = new JRadioButton(VWResource.s_saveConfigurationFileLocal);
                }
            }
            this.m_saveLocalRadioButton.setSelected(false);
            this.m_saveLocalRadioButton.addActionListener(this);
            mainPanel.add((Component)this.m_saveLocalRadioButton, gbCons);
            this.m_radioGroup = new ButtonGroup();
            this.m_radioGroup.add(this.m_saveAddRadioButton);
            this.m_radioGroup.add(this.m_saveLocalRadioButton);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel getButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
            this.m_yesButton = new JButton(VWResource.s_yes);
            this.m_yesButton.addActionListener(this);
            buttonPanel.add(this.m_yesButton);
            this.m_noButton = new JButton(VWResource.s_no);
            this.m_noButton.addActionListener(this);
            buttonPanel.add(this.m_noButton);
            if (!this.m_bExit) {
                this.m_cancelButton = new JButton(VWResource.s_cancel);
                this.m_cancelButton.addActionListener(this);
                buttonPanel.add(this.m_cancelButton);
            }
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void performSaveAddIDM() {
        this.m_nChoice = this.m_bSaveIDMDoc ? 0 : 1;
    }

    protected void performSaveLocal() {
        this.m_nChoice = 2;
    }

    protected void performYes() {
        this.m_nStatus = 8;
        this.setVisible(false);
    }

    protected void performNo() {
        this.m_nStatus = 16;
        this.setVisible(false);
    }

    protected void performCancel() {
        this.m_nStatus = 4;
        this.setVisible(false);
    }
}

